/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class Raycast
implements Comparator {
    private final abw world;
    private final atc origin;
    private final atc limit;
    private RaycastPolicies policies;
    public static final int MAX_IMPEDANCE = 100;
    private int impedance;
    private boolean has_been_performed_vs_blocks;
    private boolean has_been_performed_vs_entities;
    private RaycastCollision block_collision;
    private List entity_collisions;
    private nn originator;
    private boolean has_produced_collisions;
    private boolean is_for_player_selection;

    public Raycast() {
        this.world = null;
        this.origin = null;
        this.limit = null;
    }

    public Raycast(abw world) {
        this.world = world;
        this.origin = world.getVec3();
        this.limit = world.getVec3();
    }

    public Raycast(abw world, atc origin) {
        this.world = world;
        this.origin = origin.copy();
        this.limit = world.getVec3();
    }

    public Raycast(abw world, atc origin, atc limit) {
        this.world = world;
        this.origin = origin.copy();
        this.limit = limit.copy();
    }

    private Raycast(abw world, atc origin, atc normalized_direction, double distance_to_limit) {
        this(world, origin, origin.applyDirectionAndDistance(normalized_direction, distance_to_limit));
    }

    public Raycast(of observer, float partial_tick) {
        this(observer, partial_tick, 16.0);
    }

    public Raycast(of observer, float partial_tick, double distance_to_limit) {
        this(observer.q, observer.getEyePosition(partial_tick), observer.j(partial_tick), distance_to_limit);
        this.originator = observer;
    }

    public abw getWorld() {
        return this.world;
    }

    public atc getOrigin() {
        return this.origin;
    }

    public atc getLimit() {
        return this.limit;
    }

    public Raycast setOrigin(atc vec3) {
        if (this.has_produced_collisions) {
            atv.setErrorMessage("setOrigin: cannot change origin after raycast has produced collisions");
            new Exception().printStackTrace();
            return this;
        }
        this.origin.setComponents(vec3);
        return this;
    }

    public Raycast setLimit(atc vec3) {
        this.limit.setComponents(vec3);
        return this;
    }

    public Raycast setLimitToBlockCollisionPoint() {
        this.setLimit(this.block_collision.position_hit);
        return this;
    }

    public Raycast setOriginAndLimit(atc origin, atc limit) {
        this.setOrigin(origin);
        this.setLimit(limit);
        return this;
    }

    public Raycast setOriginAndLimitForLookVector(of observer, float partial_tick) {
        return this.setOriginAndLimitForLookVector(observer, partial_tick, 16.0);
    }

    public Raycast setOriginAndLimitForLookVector(of observer, float partial_tick, double distance_to_limit) {
        this.setOriginator(observer);
        atc origin = observer.getEyePosition(partial_tick);
        return this.setOriginAndLimit(origin, origin.applyDirectionAndDistance(observer.j(partial_tick), distance_to_limit));
    }

    public Raycast setOriginator(nn originator) {
        this.originator = originator;
        return this;
    }

    public nn getOriginator() {
        return this.originator;
    }

    public Raycast setHasProducedCollisions() {
        this.has_produced_collisions = true;
        return this;
    }

    public Raycast setPolicies(RaycastPolicies policies) {
        if (this.policies != null) {
            atv.setErrorMessage("setPolicies: raycast already has a policies object");
            new Exception().printStackTrace();
        }
        this.policies = policies;
        return this;
    }

    public Raycast setForSelection(boolean hit_liquids) {
        this.setPolicies(RaycastPolicies.for_selection(hit_liquids));
        return this;
    }

    public Raycast setForPlayerSelection() {
        this.is_for_player_selection = true;
        return this;
    }

    public boolean isForPlayerSelection() {
        return this.is_for_player_selection;
    }

    public Raycast setForVision(boolean ignore_leaves) {
        this.setPolicies(RaycastPolicies.for_vision(ignore_leaves));
        return this;
    }

    public Raycast setForPhysicalReach() {
        this.setPolicies(RaycastPolicies.for_physical_reach);
        return this;
    }

    public Raycast setForBluntProjectile(nn entity) {
        this.setPolicies(RaycastPolicies.for_blunt_projectile);
        this.setOriginator(entity);
        return this;
    }

    public Raycast setForThrownWeb(nn entity) {
        this.setPolicies(RaycastPolicies.for_selection_hit_liquids);
        this.setOriginator(entity);
        return this;
    }

    public Raycast setForPiercingProjectile(nn entity) {
        this.setPolicies(RaycastPolicies.for_piercing_projectile);
        this.setOriginator(entity);
        return this;
    }

    public boolean alwaysIgnoreLiquids() {
        return this.policies.alwaysIgnoreLiquids();
    }

    public Raycast setMultipleEntities(boolean multiple_entities) {
        this.policies.setMultipleEntities(multiple_entities);
        return this;
    }

    public Raycast setIncludeNonCollidableEntities(boolean include_non_collidable_entities) {
        this.policies.setIncludeNonCollidableEntities(include_non_collidable_entities);
        return this;
    }

    public Raycast clearImpedance() {
        this.impedance = 0;
        return this;
    }

    private int addImpedance(int impedance) {
        this.impedance += impedance;
        return this.impedance;
    }

    public boolean isFullyImpeded(int policy) {
        if (policy == -1) {
            return true;
        }
        if (policy == 0) {
            return false;
        }
        if (policy >= 1 && policy <= 9) {
            return this.addImpedance(policy * 10) >= 100;
        }
        if (policy == 11) {
            return this.originator == null ? false : RNG.chance_in_10[++this.originator.raycast_seed_offset + this.originator.k & Short.MAX_VALUE] && RNG.chance_in_4[++this.originator.raycast_seed_offset + this.originator.k & Short.MAX_VALUE];
        }
        if (policy == 15) {
            return this.originator == null ? false : RNG.chance_in_2[++this.originator.raycast_seed_offset + this.originator.k & Short.MAX_VALUE] && RNG.chance_in_4[++this.originator.raycast_seed_offset + this.originator.k & Short.MAX_VALUE];
        }
        atv.setErrorMessage("isFullyImpeded: unhandled policy " + policy);
        return true;
    }

    public boolean ignoreBlock(aqz block, abw world, int x2, int y2, int z2) {
        return this.policies.ignoreBlock(block, world, x2, y2, z2, this);
    }

    private void setBlockCollision(RaycastCollision rc2) {
        if (rc2 != null && rc2.raycast != this) {
            atv.setErrorMessage("setBlockCollision: rc.raycast!=this");
            new Exception().printStackTrace();
        }
        this.block_collision = rc2;
    }

    public Raycast performVsBlocks() {
        this.has_been_performed_vs_blocks = true;
        RaycastCollision[] rc2 = new RaycastCollision[4];
        double x_coord = this.origin.c;
        double z_coord = this.origin.e;
        this.origin.c = x_coord - 1.0E-4;
        rc2[0] = this.world.tryRaycastVsBlocks(this);
        this.origin.c = x_coord + 1.0E-4;
        rc2[1] = this.world.tryRaycastVsBlocks(this);
        this.origin.c = x_coord;
        this.origin.e = z_coord - 1.0E-4;
        rc2[2] = this.world.tryRaycastVsBlocks(this);
        this.origin.e = z_coord + 1.0E-4;
        rc2[3] = this.world.tryRaycastVsBlocks(this);
        this.origin.e = z_coord;
        double shortest_distance_to_collision = 0.0;
        this.block_collision = null;
        for (int i2 = 0; i2 < rc2.length; ++i2) {
            if (rc2[i2] == null) continue;
            double distance = rc2[i2].getDistanceFromOriginToCollisionPoint();
            if (this.block_collision != null && !(distance < shortest_distance_to_collision)) continue;
            this.setBlockCollision(rc2[i2]);
            shortest_distance_to_collision = distance;
        }
        return this;
    }

    public Raycast performVsBlocksSingle() {
        this.has_been_performed_vs_blocks = true;
        this.setBlockCollision(this.world.tryRaycastVsBlocks(this));
        return this;
    }

    public Raycast performVsEntities() {
        double max_z;
        double min_z;
        double max_y;
        double min_y;
        double max_x;
        double min_x;
        this.has_been_performed_vs_entities = true;
        this.entity_collisions = new ArrayList();
        if (this.origin.c < this.limit.c) {
            min_x = this.origin.c;
            max_x = this.limit.c;
        } else {
            min_x = this.limit.c;
            max_x = this.origin.c;
        }
        if (this.origin.d < this.limit.d) {
            min_y = this.origin.d;
            max_y = this.limit.d;
        } else {
            min_y = this.limit.d;
            max_y = this.origin.d;
        }
        if (this.origin.e < this.limit.e) {
            min_z = this.origin.e;
            max_z = this.limit.e;
        } else {
            min_z = this.limit.e;
            max_z = this.origin.e;
        }
        asx bb2 = new asx(min_x, min_y, min_z, max_x, max_y, max_z);
        List entities = this.world.b(this.originator, bb2.b(1.0, 1.0, 1.0));
        if (this.policies.getMultipleEntities()) {
            for (int i2 = 0; i2 < entities.size(); ++i2) {
                nn entity = (nn)entities.get(i2);
                if (!this.policies.getNonCollidableEntityPolicy() && !entity.L() || this.originator != null && this.originator.cannotRaycastCollideWith(entity)) continue;
                float cbs = entity.getCollisionBorderSize(this.originator);
                asx effective_collision_box = entity.E.b(cbs, cbs, cbs);
                entity.modifyEffectiveCollisionBoxForRaycastFromEntity(effective_collision_box, this.originator);
                if (effective_collision_box == null) continue;
                if (effective_collision_box.a(this.origin)) {
                    this.entity_collisions.add(new RaycastCollision(this, entity, new AABBIntercept(this.origin.copy(), null)));
                    continue;
                }
                AABBIntercept intercept = effective_collision_box.calculateIntercept(this.world, this.origin, this.limit);
                if (intercept == null) continue;
                this.entity_collisions.add(new RaycastCollision(this, entity, intercept));
            }
            Collections.sort(this.entity_collisions, this);
        } else {
            nn nearest_collided_entity = null;
            AABBIntercept nearest_intercept = null;
            double distance_to_nearest_collision = 0.0;
            for (int i3 = 0; i3 < entities.size(); ++i3) {
                nn entity = (nn)entities.get(i3);
                if (!this.policies.getNonCollidableEntityPolicy() && !entity.L() || this.originator != null && this.originator.cannotRaycastCollideWith(entity)) continue;
                float cbs = entity.getCollisionBorderSize(this.originator);
                asx effective_collision_box = entity.E.b(cbs, cbs, cbs);
                entity.modifyEffectiveCollisionBoxForRaycastFromEntity(effective_collision_box, this.originator);
                if (effective_collision_box == null) continue;
                if (effective_collision_box.a(this.origin)) {
                    nearest_collided_entity = entity;
                    nearest_intercept = new AABBIntercept(this.origin.copy(), null);
                    break;
                }
                AABBIntercept intercept = effective_collision_box.calculateIntercept(this.world, this.origin, this.limit);
                if (intercept == null) continue;
                double distance_to_collision = this.origin.d(intercept.position_hit);
                if (nearest_collided_entity != null && !(distance_to_collision < distance_to_nearest_collision)) continue;
                nearest_collided_entity = entity;
                nearest_intercept = intercept;
                distance_to_nearest_collision = distance_to_collision;
            }
            if (nearest_collided_entity != null) {
                this.entity_collisions.add(new RaycastCollision(this, nearest_collided_entity, nearest_intercept));
            }
        }
        return this;
    }

    public Raycast performVsBlocksAndEntities() {
        this.performVsBlocks();
        this.performVsEntities();
        return this;
    }

    public int compare(Object a2, Object b2) {
        double distance_b;
        RaycastCollision rc_a = (RaycastCollision)a2;
        RaycastCollision rc_b = (RaycastCollision)b2;
        double distance_a = this.origin.d(rc_a.position_hit);
        return distance_a < (distance_b = this.origin.d(rc_b.position_hit)) ? -1 : (distance_a > distance_b ? 1 : 0);
    }

    private boolean hasBeenPerformedVsBlocksOrEntities() {
        return this.has_been_performed_vs_blocks || this.has_been_performed_vs_entities;
    }

    public boolean hasBlockCollision() {
        if (!this.hasBeenPerformedVsBlocksOrEntities()) {
            atv.setErrorMessage("hasBlockCollision: raycast was never performed vs blocks or entities");
            new Exception().printStackTrace();
        }
        return this.block_collision != null;
    }

    public boolean hasNoBlockCollision() {
        return !this.hasBlockCollision();
    }

    public RaycastCollision getNearestEntityCollision() {
        if (!this.hasBeenPerformedVsBlocksOrEntities()) {
            atv.setErrorMessage("getNearestEntityCollision: raycast was never performed vs blocks or entities");
            new Exception().printStackTrace();
        }
        return this.entity_collisions.isEmpty() ? null : (RaycastCollision)this.entity_collisions.get(0);
    }

    public boolean hasEntityCollisions() {
        if (!this.hasBeenPerformedVsBlocksOrEntities()) {
            atv.setErrorMessage("hasEntityCollisions: raycast was never performed vs blocks or entities");
            new Exception().printStackTrace();
        }
        return this.entity_collisions != null && !this.entity_collisions.isEmpty();
    }

    public boolean hasCollisions() {
        return this.hasBlockCollision() || this.hasEntityCollisions();
    }

    public boolean hasNoCollisions() {
        return !this.hasCollisions();
    }

    public RaycastCollision getBlockCollision() {
        if (!this.hasBeenPerformedVsBlocksOrEntities()) {
            atv.setErrorMessage("getBlockCollision: raycast was never performed vs blocks or entities");
            new Exception().printStackTrace();
        }
        return this.block_collision;
    }

    public RaycastCollision getBlockCollision(atc limit) {
        return this.setLimit(limit).performVsBlocks().getBlockCollision();
    }

    public boolean checkForNoBlockCollision(atc limit) {
        return this.getBlockCollision(limit) == null;
    }

    public RaycastCollision getBlockCollision(atc origin, atc limit) {
        return this.setOriginAndLimit(origin, limit).performVsBlocks().getBlockCollision();
    }

    public boolean checkForNoBlockCollision(atc origin, atc limit) {
        return this.getBlockCollision(origin, limit) == null;
    }

    public List getEntityCollisions() {
        if (!this.hasBeenPerformedVsBlocksOrEntities()) {
            atv.setErrorMessage("getEntityCollisions: raycast was never performed vs blocks or entities");
            new Exception().printStackTrace();
        }
        return this.entity_collisions;
    }

    private float calcEntityBiasMethod2(double distance_to_entity_intersection, nn collided_entity) {
        float entity_bias = -collided_entity.getCollisionBorderSize(this.originator) * 3.0f;
        if (this.originator instanceof uf) {
            RaycastCollision rc2 = this.world.getBlockCollisionForPhysicalReach(this.origin, this.limit);
            if (rc2 == null || rc2.getDistanceFromOriginToCollisionPoint() > distance_to_entity_intersection + (double)(collided_entity.getCollisionBorderSize(this.originator) * 3.0f)) {
                entity_bias += 0.75f;
            }
        } else if (this.originator instanceof uh) {
            // empty if block
        }
        return entity_bias;
    }

    public RaycastCollision getNearestCollision() {
        float entity_bias;
        if (this.hasNoCollisions()) {
            return null;
        }
        if (!this.hasEntityCollisions()) {
            return this.block_collision;
        }
        RaycastCollision nearest_entity_collision = this.getNearestEntityCollision();
        if (!this.hasBlockCollision()) {
            return nearest_entity_collision;
        }
        double distance_to_block_intersection = this.block_collision.getDistanceFromOriginToCollisionPoint();
        double distance_to_entity_intersection = nearest_entity_collision.getDistanceFromOriginToCollisionPoint();
        return distance_to_entity_intersection - (double)(entity_bias = this.calcEntityBiasMethod2(distance_to_entity_intersection, nearest_entity_collision.getEntityHit())) <= distance_to_block_intersection ? nearest_entity_collision : this.block_collision;
    }

    public RaycastCollision getNearestCollisionReachableByObserver(EnumEntityReachContext entity_reach_context, float partial_tick) {
        RaycastCollision nearest_rc = this.getNearestCollision();
        if (nearest_rc == null) {
            return null;
        }
        if (nearest_rc.isBlock()) {
            atc[] block_reach_from_points;
            double reach;
            if (this.originator.isEntityPlayer()) {
                uf player = (uf)this.originator;
                reach = player.getReach(nearest_rc.getBlockHit(), nearest_rc.block_hit_metadata);
                block_reach_from_points = player.getBlockReachFromPoints(partial_tick);
            } else {
                reach = 16.0;
                block_reach_from_points = new atc[]{this.originator.isEntityLivingBase() ? this.originator.getAsEntityLivingBase().getPrimaryPointOfAttack() : this.originator.getCenterPoint()};
            }
            for (int i2 = 0; i2 < block_reach_from_points.length; ++i2) {
                if (!(block_reach_from_points[i2].distanceTo((double)nearest_rc.block_hit_x + 0.5, (double)nearest_rc.block_hit_y + 0.5, (double)nearest_rc.block_hit_z + 0.5) <= reach)) continue;
                return nearest_rc;
            }
            return null;
        }
        double reach = entity_reach_context == null ? 16.0 : (this.originator.isEntityPlayer() ? (double)this.originator.getAsPlayer().getReach(entity_reach_context, nearest_rc.getEntityHit()) : (double)this.originator.getAsEntityLiving().getReach());
        return nearest_rc.getDistanceFromOriginToCollisionPoint() <= reach ? nearest_rc : null;
    }

    public static RaycastCollision getShortestRaycastCollision(RaycastCollision[] rc2) {
        RaycastCollision shortest_rc = null;
        double shortest_distance = 0.0;
        for (int i2 = 0; i2 < rc2.length; ++i2) {
            if (rc2[i2] == null) continue;
            double distance = rc2[i2].getDistanceFromOriginToCollisionPoint();
            if (shortest_rc != null && !(distance < shortest_distance)) continue;
            shortest_rc = rc2[i2];
            shortest_distance = distance;
        }
        return shortest_rc;
    }

    public String toString() {
        if (!this.hasBeenPerformedVsBlocksOrEntities()) {
            return null;
        }
        StringBuffer sb2 = new StringBuffer();
        if (this.block_collision != null) {
            sb2.append(this.block_collision + (this.hasEntityCollisions() ? ", " : ""));
        }
        if (this.hasEntityCollisions()) {
            if (this.policies.getMultipleEntities()) {
                Iterator i2 = this.entity_collisions.iterator();
                sb2.append((RaycastCollision)i2.next());
                while (i2.hasNext()) {
                    RaycastCollision rc2 = (RaycastCollision)i2.next();
                    sb2.append(", " + rc2);
                }
            } else {
                RaycastCollision rc3 = this.getNearestEntityCollision();
                sb2.append(rc3 + " @ " + StringHelper.formatFloat((float)rc3.getDistanceFromOriginToCollisionPoint()));
            }
        }
        return sb2.toString();
    }

    private static boolean coordsExistInArray(int x2, int y2, int z2, int[] coords, int num_coord_triplets) {
        for (int i2 = 0; i2 < num_coord_triplets; ++i2) {
            int offset = i2 * 3;
            if (coords[offset] != x2 || coords[offset + 1] != y2 || coords[offset + 2] != z2) continue;
            return true;
        }
        return false;
    }

    public static int[] getFullBlockIntercepts(atc origin, atc limit) {
        double distance = origin.d(limit);
        int[] coords = new int[((int)distance + 3) * 4 * 3];
        int num_coord_triplets = 1;
        coords[0] = origin.getBlockX();
        coords[1] = origin.getBlockY();
        coords[2] = origin.getBlockZ();
        int limit_x = limit.getBlockX();
        int limit_y = limit.getBlockY();
        int limit_z = limit.getBlockZ();
        atc pos = origin.copy();
        atc normalized_vector = origin.copy().b(limit.c - origin.c, limit.d - origin.d, limit.e - origin.e).a();
        asx bb2 = asx.a().getAABB();
        while (true) {
            int x2 = pos.getBlockX();
            int y2 = pos.getBlockY();
            int z2 = pos.getBlockZ();
            for (int dx2 = -1; dx2 <= 1; ++dx2) {
                for (int dy2 = -1; dy2 <= 1; ++dy2) {
                    for (int dz2 = -1; dz2 <= 1; ++dz2) {
                        if (Raycast.coordsExistInArray(x2 + dx2, y2 + dy2, z2 + dz2, coords, num_coord_triplets)) continue;
                        bb2.setBounds(x2 + dx2, y2 + dy2, z2 + dz2, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                        AABBIntercept intercept = bb2.calculateIntercept(null, origin, limit);
                        if (intercept == null) continue;
                        int offset = num_coord_triplets * 3;
                        coords[offset] = x2 + dx2;
                        coords[offset + 1] = y2 + dy2;
                        coords[offset + 2] = z2 + dz2;
                        ++num_coord_triplets;
                    }
                }
            }
            if (x2 == limit_x && y2 == limit_y && z2 == limit_z || pos.d(origin) > distance) break;
            pos.c += normalized_vector.c;
            pos.d += normalized_vector.d;
            pos.e += normalized_vector.e;
        }
        int[] coords_trimmed = new int[num_coord_triplets * 3];
        System.arraycopy(coords, 0, coords_trimmed, 0, num_coord_triplets * 3);
        return coords_trimmed;
    }
}

